#!/bin/bash
#
environment=$1
plat_version=$2
MOUNT_DIR=`jq -r '.MOUNT_DIR' /tmp/EnvironmentForm.json`
dockerkey=`jq -r '.key.docker' /tmp/EnvironmentForm.json`
rootkey=`jq -r '.key.root' /tmp/EnvironmentForm.json`
jenkinskey=`jq -r '.key.jenkins' /tmp/EnvironmentForm.json`

#添加用户组
function GroupAdd() {
    [ `grep -w "^docker" /etc/group | wc -l` -eq 0 ] && groupadd -g 3001 docker
    [ `grep -w "^app" /etc/group | wc -l` -eq 0 ] && groupadd -g 2002 app
    [ `grep -w "^d-chinapnr" /etc/group | wc -l` -eq 0 ] && groupadd -g 2001 d-chinapnr
    [ `grep -w "^dockerroot" /etc/group | wc -l` -eq 0 ] && groupadd -g 2003 dockerroot
}

#添加d-chianpnr用户
function userAdd-d-chianpnr() {
  useradd -u 2001 -g d-chinapnr -G app,docker -d ${MOUNT_DIR}/d-chinapnr d-chinapnr
  echo "d-chinapnr@QW700"|passwd --stdin d-chinapnr
  chage -M 99999 d-chinapnr
  echo "d-chinapnr" >> /etc/sshusers
  echo "d-chinapnr ALL=(ALL) /usr/bin/passwd" >>/etc/sudoers
}

#添加docker用户,并创建相应的目录
function userAdd-docker() {
  useradd -g docker -G dockerroot,app -d ${MOUNT_DIR}/docker -s /bin/bash docker
  id docker && chage -M 99999 docker
  id rpc && chage -M 99999 rpc
  DHD=${MOUNT_DIR}/docker
  #建立docker用户相关的目录和文件
  mkdir -p ${MOUNT_DIR}/SFiles ${MOUNT_DIR}/etc ${MOUNT_DIR}/share ${MOUNT_DIR}/logfile /bea
  touch ${MOUNT_DIR}/upyunchinapnr
  chown -R docker:docker ${MOUNT_DIR}/SFiles ${MOUNT_DIR}/etc ${MOUNT_DIR}/share ${MOUNT_DIR}/logfile /bea ${MOUNT_DIR}/upyunchinapnr
  chmod -R 770 ${MOUNT_DIR}/SFiles ${MOUNT_DIR}/etc ${MOUNT_DIR}/share ${MOUNT_DIR}/logfile /bea
  chmod 440 ${MOUNT_DIR}/upyunchinapnr

  #mkdir -p ${MOUNT_DIR}/SFiles ${MOUNT_DIR}/etc ${MOUNT_DIR}/share ${MOUNT_DIR}/logfile /bea ${MOUNT_DIR}/alichinapnr
  #chown -R docker:docker ${MOUNT_DIR}/SFiles ${MOUNT_DIR}/etc ${MOUNT_DIR}/share ${MOUNT_DIR}/logfile /bea ${MOUNT_DIR}/alichinapnr
  #chmod -R 770 ${MOUNT_DIR}/SFiles ${MOUNT_DIR}/etc ${MOUNT_DIR}/share ${MOUNT_DIR}/logfile /bea
  #chmod 440 ${MOUNT_DIR}/alichinapnr

  #docker可sudo执行的脚本
  cp -a /tmp/docker_script/*.sh ${MOUNT_DIR}/docker/
  chown root: ${MOUNT_DIR}/docker/*.sh
  chmod 500 ${MOUNT_DIR}/docker/*.sh
  echo "docker ALL=(ALL) NOPASSWD: /bin/su - *,!/bin/su * root*,!/bin/su root*,/root/variate.sh,$DHD/useradd.sh,$DHD/userdel.sh,/usr/bin/netstat,/usr/sbin/lsof,/usr/sbin/tcpdump,$DHD/udprmt.sh,$DHD/udclz.sh,$DHD/dockerstart.sh,$DHD/dockerstop.sh,$DHD/get_sysconfig.sh,$DHD/passwd.sh,!$DHD/passwd.sh root" >> /etc/sudoers


  #添加docker用户公钥
  [ ! -d ${MOUNT_DIR}/docker/.ssh ] && mkdir -p ${MOUNT_DIR}/docker/.ssh
  #[ ! -f ${MOUNT_DIR}/docker/.ssh/authorized_keys ] && tech ${MOUNT_DIR}/docker/.ssh/authorized_keys
  echo ${dockerkey} >> ${MOUNT_DIR}/docker/.ssh/authorized_keys
  echo ${jenkinskey} >> ${MOUNT_DIR}/docker/.ssh/authorized_keys
  chmod 700 ${MOUNT_DIR}/docker/.ssh
  chmod 600 ${MOUNT_DIR}/docker/.ssh/authorized_keys
  chown -R docker: ${MOUNT_DIR}/docker/.ssh

  mkpasswd -l 11 -d 1 -C 1 -s 1 -v docker
}

#配置root账号的公钥
function user-root() {
  [ ! -d /root/.ssh ] && mkdir -p /root/.ssh
  [ ! -f /root/.ssh/authorized_keys ] && echo > /root/.ssh/authorized_keys
  chmod 700 /root/.ssh
  chmod 600 /root/.ssh/authorized_keys
  chown -R root: /root/.ssh
  echo ${rootkey} >> /root/.ssh/authorized_keys
  echo 'pnr.comv5!@#' | passwd --stdin root

}

function main() {
  GroupAdd
  userAdd-d-chianpnr
  userAdd-docker
  user-root
}

main
echo "`date "+%Y-%m-%d %H:%M:%S"` c_adduser.sh                      done" >>/root/logs/install.log
