#!/bin/bash
#set -ex
environment=$1
plat_version=$2
region_name=`jq -r '.region_name' /tmp/EnvironmentForm.json`
ossAccessKeyID=`jq -r '.ossAccessKeyID' /tmp/EnvironmentForm.json`
ossAccessKeySecret=`jq -r '.ossAccessKeySecret' /tmp/EnvironmentForm.json`



yum update -y
function install-common() {
  rpm -q expect || yum install -y expect >/dev/null 2>&1
  rpm -q wget || yum install -y wget >/dev/null 2>&1
  rpm -q expect || yum install -y expect >/dev/null 2>&1
  rpm -q python-pip || yum install -y python-pip >/dev/null 2>&1
  rpm -q lrzsz || yum install -y lrzsz >/dev/null 2>&1
  rpm -q nfs || yum install -y nfs >/dev/null 2>&1
  rpm -q nfs-utils || yum install -y nfs-utils >/dev/null 2>&1
  rpm -q telnet || yum install -y telnet >/dev/null 2>&1
  rpm -q iftop || yum install -y iftop >/dev/null 2>&1
  rpm -q java-1.8.0-openjdk || yum install -y java-1.8.0-openjdk >/dev/null 2>&1
  rpm -q net-tools || yum install -y net-tools >/dev/null 2>&1
  rpm -q lsof || yum install -y lsof >/dev/null 2>&1
  rpm -q gcc-c++ || yum install -y gcc-c++ > /dev/null 2>&1
  rpm -q pcre-devel || yum install -y pcre-devel > /dev/null 2>&1
  yum update -y >/dev/null 2>&1

}
install-common


#安装云监控插件
ARGUS_VERSION=3.4.7 /bin/bash -c "$(curl -s https://cms-agent-${region_name}.oss-cn-shanghai-internal.aliyuncs.com/Argus/agent_install_ecs-1.2.sh)"

function tmp() {
#安装日志服务插件
wget http://logtail-release-${region_name}.oss-${region_name}-internal.aliyuncs.com/linux64/logtail.sh -O logtail.sh; chmod 755 logtail.sh; ./logtail.sh install ${region_name}

#安装ossutil
mkdir -p /root/tools
cp /tmp/app/ossutil64 /root/tools/
chmod u+x /root/tools/ossutil64
/tmp/app/ossutil64_config.exp ${region_name} ${ossAccessKeyID} ${ossAccessKeySecret}

#安装日志解压缩软件snappy_tool
cp /tmp/app/snappy_tool /usr/bin/snappy_tool
chmod a+x /usr/bin/snappy_tool
}

echo "`date "+%Y-%m-%d %H:%M:%S"` c_install.sh                       done" >>/root/logs/install.log

