#!/bin/bash

MOUNT_DIR=`jq -r '.MOUNT_DIR' /tmp/EnvironmentForm.json`
jenkinskey=`jq -r '.key.jenkins' /tmp/EnvironmentForm.json`

#生成密码
function mkpasswd(){
  username=$1
  userhome=`grep  ^${username}: /etc/passwd|awk -F":" '{print $6}'`
  id ${username} && mkpasswd -l 15 -d 1 -C 1 -s 1 -v ${username} > ${userhome}/${username}.pw
  id ${username} && echo ${username} >> /etc/sshusers
}

#docker容器的ca证书
function ca-docker() {
  [ -f /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt ] && rm -rf /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  [ ! -d /etc/docker/certs.d/mydockerhub.com\:5000 ] && mkdir -p /etc/docker/certs.d/mydockerhub.com\:5000
  jq -r ".ca.test" /tmp/EnvironmentForm.json > /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  #echo -e ${catest} >> /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  chmod 644 /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  systemctl restart docker
}

#docker用户添加jenkins公钥
function key-jenkins() {
  [ ! -d ${MOUNT_DIR}/docker/.ssh ] && mkdir -p ${MOUNT_DIR}/docker/.ssh
  [ ! -f ${MOUNT_DIR}/docker/.ssh/authorized_keys ] && echo > ${MOUNT_DIR}/docker/.ssh/authorized_keys
  chmod 700 ${MOUNT_DIR}/docker/.ssh
  chmod 600 ${MOUNT_DIR}/docker/.ssh/authorized_keys
  chown -R docker: ${MOUNT_DIR}/docker/.ssh/.ssh
  echo ${jenkinskey} >> ${MOUNT_DIR}/docker/.ssh/authorized_keys

}

echo "`date "+%Y-%m-%d %H:%M:%S"` t_docker.sh                        done" >>/root/logs/install.log
