#!/bin/bash
#set -ex
####安装docker并设置开机自启动#####
#VERSION=18.09.9

#catest=`jq -r '.ca.test' EnvironmentForm.json`
environment=$1
plat_version=$2


#重新安装docker，为18版本
function docker-install(){
	#systemctl stop docker
	rpm -q docker-common && yum erase docker-common -y
	rpm -q docker-cli && yum erase docker-cli -y
	rpm -q docker && yum erase docker -y
	#yum erase docker docker-cli docker-common -y
	yum localinstall -y $(ls /tmp/app/rpm/containerd*)
	yum localinstall -y $(ls /tmp/app/rpm/docker-ce*)
}




#配置开机启动docker
function doceker-auto-start(){
  cp /usr/lib/systemd/system/docker.service /tmp
  sed -i "s/After=network.targe/After=kdump.service/g" /usr/lib/systemd/system/docker.service
cat >"/usr/lib/systemd/system/dockergrp.service"<<EOF
[Unit]
Description=Docker Application dockerroot
Documentation=http://docs.docker.com
After=docker.service
Wants=docker-storage-setup.service


[Service]
Type=notify
NotifyAccess=main
EnvironmentFile=-/run/containers/registries.conf
EnvironmentFile=-/etc/sysconfig/docker
EnvironmentFile=-/etc/sysconfig/docker-storage
EnvironmentFile=-/etc/sysconfig/docker-network
Environment=GOTRACEBACK=crash
Environment=DOCKER_HTTP_HOST_COMPAT=1
Environment=PATH=/usr/libexec/docker:/usr/bin:/usr/sbin
ExecStart=/usr/bin/chgrp dockerroot /var/run/docker.sock
ExecReload=/bin/kill -s HUP $MAINPID
LimitNOFILE=1048576
LimitNPROC=1048576
LimitCORE=infinity
TimeoutStartSec=0
Restart=on-abnormal
KillMode=process

[Install]
WantedBy=multi-user.target
EOF

systemctl enable docker.service && systemctl enable dockergrp.service
systemctl -a|grep -E "docker.service|dockergrp.service"
ls /etc/systemd/system/multi-user.target.wants|grep docker
}

#添加配置文件
function config-docker-and-start() {
  systemctl start docker && systemctl stop docker
  [ -f /etc/docker/daemon.json ] && rm -rf /etc/docker/daemon.json
  [ ! -d /etc/docker ] && mkdir -p /etc/docker
  jq -r ".daemon.json" /tmp/EnvironmentForm.json > /etc/docker/daemon.json
  #[ -d /etc/docker ] && cp ./app/daemon/daemon.json /etc/docker/daemon.json
  [ -f /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt ] && rm -rf /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  [ ! -d /etc/docker/certs.d/mydockerhub.com\:5000 ] && mkdir -p /etc/docker/certs.d/mydockerhub.com\:5000
  if [ ${environment} == "prod" ];then
    jq -r ".ca.$environment" /tmp/EnvironmentForm.json > /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  else
    jq -r ".ca.other" /tmp/EnvironmentForm.json > /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  fi
  #jq -r ".ca.$environment" EnvironmentForm.json > /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  #jq -r ".ca.test" EnvironmentForm.json > /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  #echo -e ${catest} >> /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  chmod 644 /etc/docker/certs.d/mydockerhub.com\:5000/ca.crt
  systemctl restart docker
}

#安装docker-compose
function docker-compose-install() {
  cp -a /tmp/app/other/docker-compose /usr/local/bin/docker-compose
  #curl -L "https://github.com/docker/compose/releases/download/1.26.2/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose
  chmod 775 /usr/local/bin/docker-compose
  ln -s /usr/local/bin/docker-compose /usr/bin/docker-compose
  chmod 775 /usr/bin/docker-compose
  docker-compose --version

}

function main(){
  docker-install  #安装docker
  doceker-auto-start #设置开机启动
  config-docker-and-start #配置docker并启动
  docker-compose-install #安装docker-compose

}

main


echo "`date "+%Y-%m-%d %H:%M:%S"` c_docker.sh                       done" >>/root/logs/install.log

