#!/bin/bash
#########设置linux的虚拟内存swap为4G


#设置4G
dd if=/dev/zero of=/swap bs=4096 count=1048576
chmod 600 /swap
#设置交换分区文件
mkswap /swap
#启动交换分区
swapon /swap
#开机自动挂载
swapon -a

#已服务的方式启动
cat >"/usr/lib/systemd/system/swap.service"<<EOF
[Unit]
Description=startswap
After=network.target


[Service]
Type=notify
NotifyAccess=main
Environment=PATH=/usr/bin:/usr/sbin
ExecStart=/usr/sbin/swapon /swap
ExecReload=/bin/kill -s HUP $MAINPID
LimitNOFILE=1048576
LimitNPROC=1048576
LimitCORE=infinity
TimeoutStartSec=0
Restart=on-abnormal
KillMode=process

[Install]
WantedBy=multi-user.target
EOF

systemctl enable swap.service

echo "`date "+%Y-%m-%d %H:%M:%S"` c_mkswap.sh                        done" >>/root/logs/install.log
