#!/bin/bash
#set -ex


#linux系统一键加固
release=` uname -r|awk -F"." '{print $(NF-1)}'`

#安装常用软件
function  yum_install(){
	yum install -y epel-release
	yum clean all
	yum makecache
	yum install -y python-pip lrzsz nfs nfs-utils telnet iftop openssl openssh java-1.8.0-openjdk docker docker-compose net-tools lsof
}

#启停常用服务
function app_enable(){
	if [ ${release} = "el7" ];then
		systemctl stop postfix
		systemctl disable postfix
		#systemctl start ntpd
		#systemctl enable ntpd
	elif [ ${release} = "el6" ];then
		/etc/init.d/postfix stop
		chkconfig postfix off
		#/etc/init.d/ntpd start
		#chkconfig ntpd on
	fi

}

####/etc/security/limits.conf
#限制着用户可以使用的最大文件数，最大线程，最大内存等资源使用量
function config_limits_conf(){
	if test `grep '*              hard    nproc           999999' /etc/security/limits.conf|wc -l` -eq 0
	then
		sed -i '$a\\*\ \ \ \ \ \ \ \ \ \ \ \ \ \ hard\ \ \ \ nproc\ \ \ \ \ \ \ \ \ \ \ 999999' /etc/security/limits.conf
	fi
	if test `grep '*              soft    nproc           999999' /etc/security/limits.conf|wc -l` -eq 0
	then
		sed -i '$a\\*\ \ \ \ \ \ \ \ \ \ \ \ \ \ soft\ \ \ \ nproc\ \ \ \ \ \ \ \ \ \ \ 999999' /etc/security/limits.conf
	fi
	if test `grep '*              soft    nofile           999999' /etc/security/limits.conf|wc -l` -eq 0
	then
		sed -i '$a\\*\ \ \ \ \ \ \ \ \ \ \ \ \ \ soft\ \ \ \ nofile\ \ \ \ \ \ \ \ \ \ \ 999999' /etc/security/limits.conf
	fi
	if test `grep '*              hard    nofile           999999' /etc/security/limits.conf|wc -l` -eq 0
	then
		sed -i '$a\\*\ \ \ \ \ \ \ \ \ \ \ \ \ \ hard\ \ \ \ nofile\ \ \ \ \ \ \ \ \ \ \ 999999' /etc/security/limits.conf
	fi
}

###/etc/security/limits.d/20-nproc.conf
###/etc/selinux/config
###/etc/ssh/ssh_config

###/etc/motd  配置命令行预警信息
function config_motd(){
	if [ -f /etc/motd ]
	then
		echo '*******************************************************************' > /etc/motd
		echo 'This is a private computer facility. Access for any reason must be specifically authorized by the owner. Unless you are so authorized, your continued access and any other use may expose you to criminal and/or civil proceedings. Usage may be monitored.' >> /etc/motd
		echo '*******************************************************************' >> /etc/motd
	fi
}

###/etc/issue 配置本地登录告警标题
function config_issue(){
	if test `egrep '（\\ v | \\ r | \\ m | \\ s）' /etc/issue|wc -l` -eq 0
	then
		echo '*******************************************************************' > /etc/issue
		echo 'This is a private computer facility. Access for any reason must be specifically authorized by the owner. Unless you are so authorized, your continued access and any other use may expose you to criminal and/or civil proceedings. Usage may be monitored.' >> /etc/issue
		echo '*******************************************************************' >> /etc/issue
	fi
	if test `egrep '（\\ v | \\ r | \\ m | \\ s）' /etc/issue.net|wc -l` -eq 0
	then
		echo '*******************************************************************' > /etc/issue.net
		echo 'This is a private computer facility. Access for any reason must be specifically authorized by the owner. Unless you are so authorized, your continued access and any other use may expose you to criminal and/or civil proceedings. Usage may be monitored.' >> /etc/issue.net
		echo '*******************************************************************' >> /etc/issue.net
	fi
}

###/etc/sysctl.conf /etc/sysctl.d/*
#关闭系统ICMP重定向消息
#确保记录可疑包
function config_sysctld(){
	#确保不接受ICMP重定向
	if test `sysctl net.ipv4.conf.default.accept_redirects|grep "net.ipv4.conf.default.accept_redirects = 0" |wc -l` -eq 0
	then
		echo "net.ipv4.conf.default.accept_redirects = 0" >> /etc/sysctl.d/redirects.conf
	fi
	if test `sysctl net.ipv4.conf.all.accept_redirects|grep "net.ipv4.conf.all.accept_redirects = 0" |wc -l` -eq 0
	then
		echo "net.ipv4.conf.all.accept_redirects = 0" >> /etc/sysctl.d/redirects.conf
	fi

	#确保不接受安全的ICMP重定向
	if test `sysctl net.ipv4.conf.all.secure_redirects|grep "net.ipv4.conf.all.secure_redirects =0"|wc -l` -eq 0
	then
		echo "net.ipv4.conf.all.secure_redirects =0" >> /etc/sysctl.d/redirects.conf
	fi

	if [ `sysctl net.ipv4.conf.default.secure_redirects|grep 'net.ipv4.conf.default.secure_redirects = 0'|wc -l` == 0 ];then
		echo "net.ipv4.conf.default.secure_redirects = 0" >> /etc/sysctl.d/redirects.conf
	fi
	#确保记录可疑包
	if test `sysctl net.ipv4.conf.all.log_martians|grep 'net.ipv4.conf.all.log_martians = 1'|wc -l` -eq 0
	then
		echo "net.ipv4.conf.all.log_martians = 1" >> /etc/sysctl.d/redirects.conf
	fi
	if test `sysctl net.ipv4.conf.default.log_martians|grep 'net.ipv4.conf.default.log_martians = 1'|wc -l` -eq 0
	then
		echo "net.ipv4.conf.default.log_martians = 1" >> /etc/sysctl.d/redirects.conf
	fi

	#忽略广播ICMP请求
	if test `sysctl net.ipv4.icmp_echo_ignore_broadcasts|grep 'net.ipv4.icmp_echo_ignore_broadcasts = 1'|wc -l` -eq 0
	then
		echo "net.ipv4.icmp_echo_ignore_broadcasts = 1" >> /etc/sysctl.d/redirects.conf
	fi

	#忽略伪造的ICMP响应
	if test `sysctl net.ipv4.icmp_ignore_bogus_error_responses|grep 'net.ipv4.icmp_ignore_bogus_error_responses = 1'|wc -l` -eq 0
	then
		echo "net.ipv4.icmp_ignore_bogus_error_responses = 1" >> /etc/sysctl.d/redirects.conf
	fi

	#确保使用了反向路径过滤
	if test `sysctl net.ipv4.conf.all.rp_filter|grep 'net.ipv4.conf.all.rp_filter = 1'|wc -l` -eq 0
	then
		echo "net.ipv4.conf.all.rp_filter = 1" >> /etc/sysctl.d/redirects.conf
	fi
	if test `sysctl net.ipv4.conf.default.rp_filter|grep 'net.ipv4.conf.default.rp_filter = 1'|wc -l` -eq 0
	then
		echo "net.ipv4.conf.default.rp_filter = 1" >> /etc/sysctl.d/redirects.conf
	fi

	sysctl -p /etc/sysctl.d/redirects.conf
}

#防火请设置
function config_iptables(){
	iptables -X
	iptables -F
	if [ ${release} = "el7" ];then
		systemctl stop firewalld
		systemctl disable firewalld
	elif [ ${release} = "el6" ];then
		/etc/init.d/iptables stop
		chkconfig  iptables off
	fi

}

#配置系统记账
function config_auditd(){
	sed -i '/^max_log_file\ /cmax_log_file\ =\ 8' /etc/audit/auditd.conf
	sed -i '/^space_left_action\ /cspace_left_action\ =\ syslog' /etc/audit/auditd.conf
	sed -i '/^admin_space_left_action\ /cadmin_space_left_action\ =\ SUSPEND' /etc/audit/auditd.conf
	sed -i '/^max_log_file_action\ /cmax_log_file_action\ =\ ROTATE' /etc/audit/auditd.conf
	if [ ${release} = "el7" ];then
		systemctl start auditd
		systemctl enable auditd
	elif [ ${release} = "el6" ];then
		/etc/init.d/auditd start
		chkconfig auditd on
	fi
}

#配置日志记录
function config_rsyslog(){
	if [ ${release} = "el7" ];then
		systemctl start rsyslog
		systemctl enable rsyslog
	elif [ ${release} = "el6" ];then
		/etc/init.d/rsyslog start
		chkconfig rsyslog on
	fi
}

#SSH服务器配置
function config_sshd_config(){
	chown root:root /etc/ssh/sshd_config
	chmod og-rwx  /etc/ssh/sshd_config
	sed -i '/^X11Forwarding/cX11Forwarding\ no' /etc/ssh/sshd_config
	sed -i '/^ClientAliveInterval/cClientAliveInterval\ 300' /etc/ssh/sshd_config
	sed -i '/^ClientAliveCountMax/cClientAliveCountMax\ 0' /etc/ssh/sshd_config

	if test `grep ^ClientAliveInterval /etc/ssh/sshd_config |wc -l` -eq 0
	then
		echo "ClientAliveInterval 300" >> /etc/ssh/sshd_config
	fi
	if test `grep ^ClientAliveCountMax /etc/ssh/sshd_config|wc -l` -eq 0
	then
		echo "ClientAliveCountMax 0" >> /etc/ssh/sshd_config
	fi
	if test `grep Banner /etc/ssh/sshd_config|grep -v none|wc -l` -eq 0
	then
		echo "Banner /etc/issue.net" >> /etc/ssh/sshd_config
	fi
	if test `grep -v ^# /etc/ssh/sshd_config|grep PasswordAuthentication|wc -l` -eq 0
	then
		echo "PasswordAuthentication yes" >> /etc/ssh/sshd_config
	else
		sed -i '/^PasswordAuthentication/cPasswordAuthentication\ yes' /etc/ssh/sshd_config
	fi

	if test `grep -v ^# /etc/ssh/sshd_config|grep PermitRootLogin|wc -l` -eq 0
	then
		echo "PermitRootLogin yes" >> /etc/ssh/sshd_config
	else
		sed -i '/^PermitRootLogin/cPermitRootLogin\ yes' /etc/ssh/sshd_config
	fi



	#限定指定用户通过SSH登录系统
	if test `grep file /etc/pam.d/sshd |wc -l` -eq 0
	then
		sed -i '1i\auth\ \ \ \ \ \ \ required\ \ \ \ \ pam_listfile.so\ \ onerr=fail\ item=user\ sense=allow\ file=\/etc\/sshusers' /etc/pam.d/sshd
	fi
	#echo 'root' >> /etc/sshusers    #待删除

	#配置PAM身份验证模块
	sed -i '/pam_pwquality\.so/cpassword\ requisite\ pam_pwquality\.so\ try_first_pass\ retry\ =\ 3' /etc/pam.d/password-auth


	####配置密码长度和复杂度
	#修改密码的长度为11位
	if test `grep -v ^# /etc/security/pwquality.conf|grep minlen|wc -l` -eq 0
	then
		echo "minlen = 11" >> /etc/security/pwquality.conf
	else
		sed -i '/^minlen/cminlen\ =\ 11' /etc/security/pwquality.conf
	fi

	#修改密码的数字个数，-1表示至少一个
	if test `grep -v ^# /etc/security/pwquality.conf|grep dcredit|wc -l` -eq 0
	then
		echo "dcredit = -1" >> /etc/security/pwquality.conf
	else
		sed -i '/^dcredit/cdcredit\ =\ -1' /etc/security/pwquality.conf
	fi

	#修改密码的大写字母个数，-1标识至少一个
	if test `grep -v ^# /etc/security/pwquality.conf|grep ucredit|wc -l` -eq 0
	then
		echo "ucredit = -1" >> /etc/security/pwquality.conf
	else
		sed -i '/^ucredit/cucredit\ =\ -1' /etc/security/pwquality.conf
	fi

	#修改密码的特殊字符个数，-1标识至少一个
	if test `grep -v ^# /etc/security/pwquality.conf|grep ocredit|wc -l` -eq 0
	then
		echo "ocredit = -1" >> /etc/security/pwquality.conf
	else
		sed -i '/^ocredit/cocredit\ =\ -1' /etc/security/pwquality.conf
	fi

	#修改密码的小写字母个数，-1表示至少一个
	if test `grep -v ^# /etc/security/pwquality.conf|grep lcredit|wc -l` -eq 0
	then
		echo "lcredit = -1" >> /etc/security/pwquality.conf
	else
		sed -i '/^lcredit/clcredit\ =\ -1' /etc/security/pwquality.conf
	fi


	#确保哈希算法为SHA-512
	#if test `grep "password    sufficient    pam_unix.so md5" /etc/pam.d/password-auth|wc -l` -eq 0
	#then
	#	echo "password    sufficient    pam_unix.so md5" >> /etc/pam.d/password-auth
	#fi
	authconfig --passalgo=sha512 --update

	#设置用户umask为027
	if test `grep umask /etc/profile |wc -l` -eq 0
	then
	  #sed -i "s/^.*user10.*$/aaaaaaaaaa/" useradd.txt
	  sed -i "s/^.*umask.*$/\ \ \ \ umask\ 027/" /etc/profile
	else
	  echo "umask 027" >> /etc/profile
	fi
	if test `grep umask /etc/bashrc |wc -l` -eq 0
	then
	  #sed -i "s/^.*user10.*$/aaaaaaaaaa/" useradd.txt
	  sed -i "s/^.*umask.*$/\ \ \ \ umask\ 027/" /etc/bashrc
	else
	  echo "umask 027" >> /etc/bashrc
	fi


	#用户账户和环境
	#密码有效期90天
	sed -i '/^PASS_MAX_DAYS/cPASS_MAX_DAYS\ \ \ 90' /etc/login.defs
	sed -i '/^GID_MIN/cGID_MIN\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 3001' /etc/login.defs
	sed -i '/^UID_MIN/cUID_MIN\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 3001' /etc/login.defs
	sed -i '/^UMASK/cUMASK\ \ \ \ \ \ \ \ \ \ \ 027' /etc/login.defs

	#设置用户shell超时900秒和历史命令记录30条
	if test `grep TMOUT /etc/bashrc |wc -l` -eq 0
	then
		echo "export TMOUT=900" >> /etc/bashrc
	else
		sed -i '/TMOUT/cexport\ TMOUT=900' /etc/bashrc
	fi

	if test `grep HISTSIZE /etc/bashrc |wc -l` -eq 0
	then
		echo "export HISTSIZE=30" >> /etc/bashrc
	else
		sed -i '/HISTSIZE/cexport\ HISTSIZE=30' /etc/bashrc
	fi

	#限制对su命令的访问
	if test `grep -v ^# /etc/pam.d/su|grep pam_wheel.so|wc -l` -eq 0
	then
		echo "auth           required        pam_wheel.so use_uid" >> /etc/pam.d/su
	fi
	sed -i '/^wheel/cwheel:x:10:root' /etc/group
}

#关闭THP服务
function thp(){
	if test -f /sys/kernel/mm/transparent_hugepage/enabled
	then
		echo "never" > /sys/kernel/mm/transparent_hugepage/enabled
	fi

	if test -f /sys/kernel/mm/transparent_hugepage/defrag
	then
		echo "never" > /sys/kernel/mm/transparent_hugepage/defrag
	fi
}

#fstab的/dev/shm添加noexec 选项
function fstab() {
    grep ^tmpfs /etc/fstab && sed -i '/^tmpfs/ctmpfs\ \ \ \/dev\/shm\ \ \ \ \ \ \ \ tmpfs\ \ \ defaults,nodev,nosuid,noexec\ \ \ \ 0\ \ \ \ \ \ \ 0' /etc/fstab
    grep ^tmpfs /etc/fstab || echo "tmpfs   /dev/shm        tmpfs   defaults,nodev,nosuid,noexec    0       0" >> /etc/fstab
    mount -o remount,noexec,nosuid,nodev /tmp
    mount -o remount,noexec,nosuid,nodev /dev/shm
}

#内核参数优化
function config_sysctl(){
	cat >"/etc/sysctl.conf"<<EOF
	vm.swappiness = 0

	net.ipv4.neigh.default.gc_stale_time = 120

	# see details in https://help.aliyun.com/knowledge_detail/39428.html
	net.ipv4.conf.all.rp_filter = 0
	net.ipv4.conf.default.rp_filter = 0
	net.ipv4.conf.default.arp_announce = 2
	net.ipv4.conf.lo.arp_announce = 2
	net.ipv4.conf.all.arp_announce = 2

	# see details in https://help.aliyun.com/knowledge_detail/41334.html
	net.ipv4.tcp_max_tw_buckets = 5000
	net.ipv4.tcp_syncookies = 1
	net.ipv4.tcp_max_syn_backlog = 1024
	net.ipv4.tcp_synack_retries = 2

	net.ipv6.conf.all.disable_ipv6 = 1
	net.ipv6.conf.default.disable_ipv6 = 1
	net.ipv6.conf.lo.disable_ipv6 = 1

	kernel.sysrq = 1


	kernel.msgmni = 655360
	kernel.msgmnb = 655360000
	kernel.msgmax = 655360
	kernel.shmmax = 68719476736
	kernel.shmall = 4294967296
	kernel.sem = 250 32000 100 128
	fs.file-max = 6815744
	net.core.rmem_default = 262144
	net.core.wmem_default = 262144
	net.core.rmem_max = 4194304
	net.core.wmem_max = 1048576
	fs.aio-max-nr = 1048576
	vm.max_map_count=655360
	net.ipv4.tcp_max_syn_backlog = 20480
	net.ipv4.ip_local_port_range = 1025     65000
	net.core.netdev_max_backlog = 50000
	net.core.somaxconn = 50000
	vm.swappiness = 10
	net.ipv4.tcp_syncookies = 1
	net.ipv4.tcp_tw_reuse = 1
	net.ipv4.tcp_fin_timeout = 30


	net.ipv4.conf.all.send_redirects = 0
	net.ipv4.conf.default.send_redirects = 0
	net.ipv4.conf.all.accept_redirects = 0
	net.ipv4.conf.default.accept_redirects = 0
	net.ipv4.conf.all.secure_redirects = 0
	net.ipv4.conf.default.secure_redirects = 0

	net.ipv4.conf.all.log_martians = 1
	net.ipv4.conf.default.log_martians = 1
	net.ipv4.conf.all.rp_filter = 1
	net.ipv4.conf.default.rp_filter = 1
EOF
}

#主程序
function main(){
	#yum_install         #安装常用软件
	app_enable          #启停常用服务
	thp                 #关闭THP服务
	config_limits_conf  #限制着用户可以使用的最大文件数，最大线程，最大内存等资源使用量
	config_motd         #配置命令行预警信息
	config_issue        #配置本地登录告警标题
	fstab               #/tmp添加nodev/nosuid/noexec挂载选项

	config_iptables     #清空并关闭防火墙
	config_auditd       #配置系统记账
	config_rsyslog      #配置日志记录
	config_sshd_config  #SSH服务器配置
	config_sysctl       #内核参数优化
	config_sysctld      #关闭系统ICMP重定向消息和可疑包
}

main

echo "`date "+%Y-%m-%d %H:%M:%S"` c_security_reinforce.sh            done" >>/root/logs/install.log
