#!/bin/bash
# 日志文件采集偏移量记录，建议放在临时目录里  $position  /tmp/position.yaml
# promtail采集器配置文件路径 $config_file /app/docker/promtail/config.yaml
# promtail采集器路径 $promtail_file
###### 路径配置
position="/app/promtail/position.yaml"
config_file="/app/promtail/config.yaml"
promtail_file="/app/promtail/promtail"

###### 增量采集
# 只有文件不存在或者文件为空才创建position
if [ ! -f "$position" ] || [ ! -s "$position" ]; then
    echo -e "positions:\n" > $position
    find /app/promtail/logs/* -type f -exec ls -l {}   \; | awk '{print "  "$9": \""$5"\""}' >> $position
fi

###### 平滑杀掉老进程，启动新进程
ps -ef | grep $promtail_file | grep -v grep | awk '{print $2}' | xargs kill -9
# 可以用nohup启动，这里没有写
nohup $promtail_file -config.file=$config_file -config.expand-env=true >>/dev/null 2>&1 &
