#!/usr/bin/env bash

## 查看现有的ssh的版本并升级到最新版本
function pre-install() {
  ssh -V
  openssl version
  yum update openssh -y
  yum install  -y gcc gcc-c++ glibc make autoconf openssl openssl-devel pcre-devel  pam-devel
  yum install  -y pam* zlib*
}


## 升级ssl
function update-ssl() {
  #wget -c https://ftp.openssl.org/source/openssl-1.1.1k.tar.gz
  tar xfz /tmp/app/ssh/openssl-1.1.1k.tar.gz -C /opt/
  mv /usr/bin/openssl /usr/bin/openssl_bak
  mv /usr/include/openssl /usr/include/openssl_bak
  cd /opt/openssl-1.1.1k
  ./config --prefix=/usr/local/ssl shared && make && make install
  echo $?
  ln -s /usr/local/ssl/bin/openssl /usr/bin/openssl
  ln -s /usr/local/ssl/include/openssl /usr/include/openssl
  echo "/usr/local/ssl/lib" >> /etc/ld.so.conf
  /sbin/ldconfig
  openssl version
}

function update-ssh() {
  #wget -c https://openbsd.hk/pub/OpenBSD/OpenSSH/portable/openssh-8.1p1.tar.gz
  tar xfz /tmp/app/ssh/openssh-8.1p1.tar.gz -C /opt/
  cd /opt/openssh-8.1p1
  chown -R root.root /opt/openssh-8.1p1
  cp -r  /etc/ssh /tmp/
  rm -rf /etc/ssh
  ./configure --prefix=/usr/ --sysconfdir=/etc/ssh  --with-openssl-includes=/usr/local/ssl/include --with-ssl-dir=/usr/local/ssl   --with-zlib   --with-md5-passwords   --with-pam  && make && make install
  echo $?
}

function sshd_cfg() {
#修改ssh配置
cat > /etc/ssh/sshd_config <<EOF
Protocol 2
LoginGraceTime 60
PermitRootLogin yes 
MaxAuthTries 4
AuthorizedKeysFile      .ssh/authorized_keys
PasswordAuthentication  yes
UsePAM yes
ClientAliveInterval 300
ClientAliveCountMax 0
UseDNS no
PidFile /var/run/sshd.pid
Banner /etc/issue.net
Subsystem       sftp    /usr/libexec/sftp-server
EOF

#修改ssh服务文件
cp -a /opt/openssh-8.1p1/contrib/redhat/sshd.init /etc/init.d/sshd
cp -a /opt/openssh-8.1p1/contrib/redhat/sshd.pam /etc/pam.d/sshd.pam
chmod +x /etc/init.d/sshd
chkconfig --add sshd
systemctl enable sshd
mv  /usr/lib/systemd/system/sshd.service  /opt/
mv  /usr/lib/systemd/system/sshd.socket  /opt/
chkconfig sshd on
service sshd restart
openssl version
ssh -V
}


pre-install
update-ssl
update-ssh
sshd_cfg

echo "`date "+%Y-%m-%d %H:%M:%S"` c_update_ssh.sh                      done" >>/root/logs/install.log
