#!/bin/bash
#set -ex
#自动分区和建立文件系统并设置自动挂载

environment=$1
plat_version=$2
#yum install jq
MOUNT_DIR=`jq -r '.MOUNT_DIR' /tmp/EnvironmentForm.json`
format=`jq -r '.format' /tmp/EnvironmentForm.json`

#fdisk建立分区
function  fdisk_fun(){
fdisk -u $1 <<EOF
n
p
1


w
EOF
}

#创建文件系统并挂载
function format_fun() {
	if [ `fdisk -lu ${1}|grep -oE '/dev/[sv]d[b-z]1.*'|awk '{print $4}'` -gt 0 ];then
		#mkfs -t ${format} ${1}1
		/tmp/app/mkfs.exp ${format} ${1}1
		echo `blkid ${1}1 | awk '{print $2}' | sed 's/\"//g'` ${MOUNT_DIR} ${format} defaults 0 0 >> /etc/fstab
		mount -a
	fi
}


for disk in `fdisk -l |grep -oE 'Disk /dev/[sv]d[b-z]'|awk '{print $2}'`;do
  mkdir -p ${MOUNT_DIR}
	fdisk_fun ${disk}
	format_fun ${disk}
done


echo "`date "+%Y-%m-%d %H:%M:%S"` c_fdisk.sh                         done" >>/root/logs/install.log
